#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "link.h"

extern int depmod_main(int, char **);
extern int modprobe_main(int, char **);
int debugmode=0;

int
main(int argc, char **argv)
{
	char *progname;

	if ((progname = strrchr(argv[0], '/')))
		++progname;
	else
		progname = argv[0];

	if (strcmp(progname, "depmod") == 0)
		return depmod_main(argc, argv);
	else
		return modprobe_main(argc, argv);
}

/*
 * Get kernel symbol table(s).
 *
 * Bjorn Ekwall <bj0rn@blox.se> in 1994 (C)
 */
#include "kernelsyms.h"

extern "C" syscall(int, ...);

static int get_kernel_syms(struct kernel_sym *buffer)
{
	return syscall( __NR_get_kernel_syms, buffer);
}

struct kernel_sym *ksymtab = NULL;
int nksyms;

void
load_kernel_symbols(void)
{
	nksyms = get_kernel_syms(NULL);

	if (nksyms < 0) {
		depmod_error("get_kernel_sys failed: Cannot find Kernel symbols!");
		exit(2);
	}

	if (ksymtab)
		free(ksymtab);

	if (nksyms) {
		ksymtab = (struct kernel_sym *) malloc(nksyms * sizeof *ksymtab);
		get_kernel_syms(ksymtab);
	}
}
