/*****************************************************************************
 *
 * Name:	skgipnm2.h
 * Project:	SysKonnect SK-9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.1 $
 * Date:	$Date: 2001/06/05 08:28:24 $
 * Purpose:	Defines for Private Network Management Interface
 *
 ****************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/*****************************************************************************
 *
 * History:
 *
 *	$Log: skgipnm2.h,v $
 *	Revision 1.1  2001/06/05 08:28:24  rassmann
 *	First public version.
 *	
 *
 ****************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 ******************************************************************************/

#ifndef _SKGIPNM2_H_
#define _SKGIPNM2_H_

#ifndef FALSE
#define FALSE			0
#endif

#ifndef TRUE
#define	TRUE			!(FALSE)
#endif

/*
 * General definitions
 */
#define SK_PNMI_CHIPSET			1	/* XMAC11800FP */

#define	SK_PNMI_BUS_PCI			1	/* PCI bus*/

/*
 * Actions
 */
#define SK_PNMI_ACT_IDLE		1
#define SK_PNMI_ACT_RESET		2
#define SK_PNMI_ACT_SELFTEST	3
#define SK_PNMI_ACT_RESETCNT	4

/*
 * Internal table definitions
 */
#define SK_PNMI_GET		0
#define SK_PNMI_PRESET	1
#define SK_PNMI_SET		2

#define SK_PNMI_RO		0
#define SK_PNMI_RW		1

typedef struct s_OidTabEntry {
	SK_U32		Id;
	SK_U32		InstanceNo;
	unsigned	StructSize;
	unsigned	Offset;
	int			Access;
	int			(* Func)(SK_AC *pAc, SK_IOC pIo, int action,
					SK_U32 Id, char* pBuf, unsigned int* pLen,
					SK_U32 Instance, unsigned int TableIndex);
} SK_PNMI_TAB_ENTRY;



/*
 * MAC specific data
 */
typedef struct s_PnmiStatAddr {
	SK_BOOL		GetOffset;	/* TRUE: Call GetStatVal function */
	SK_U16		Param;		/* XMAC register containing value */
} SK_PNMI_STATADDR;


/*
 * SK_PNMI_STRUCT_DATA copy offset evaluation macros
 */
#define SK_PNMI_OFF(e)		((SK_U32)(SK_UPTR)&(((SK_PNMI_STRUCT_DATA *)0)->e))
#define SK_PNMI_MAI_OFF(e)	((SK_U32)(SK_UPTR)&(((SK_PNMI_STRUCT_DATA *)0)->e))
#define SK_PNMI_VPD_OFF(e)	((SK_U32)(SK_UPTR)&(((SK_PNMI_VPD *)0)->e))
#define SK_PNMI_SEN_OFF(e)	((SK_U32)(SK_UPTR)&(((SK_PNMI_SENSOR *)0)->e))
#define SK_PNMI_CHK_OFF(e)	((SK_U32)(SK_UPTR)&(((SK_PNMI_CHECKSUM *)0)->e))
#define SK_PNMI_STA_OFF(e)	((SK_U32)(SK_UPTR)&(((SK_PNMI_STAT *)0)->e))
#define SK_PNMI_CNF_OFF(e)	((SK_U32)(SK_UPTR)&(((SK_PNMI_CONF *)0)->e))
#define SK_PNMI_RLM_OFF(e)	((SK_U32)(SK_UPTR)&(((SK_PNMI_RLMT *)0)->e))
#define SK_PNMI_MON_OFF(e)	((SK_U32)(SK_UPTR)&(((SK_PNMI_RLMT_MONITOR *)0)->e))
#define SK_PNMI_TRP_OFF(e)	((SK_U32)(SK_UPTR)&(((SK_PNMI_TRAP *)0)->e))

#define SK_PNMI_SET_STAT(b,s,o)	{									\
	SK_U32	Val32;													\
	char *pVal;														\
	Val32 = (s);													\
	pVal = (char *)(b) + ((SK_U32)(SK_UPTR)							\
		&(((SK_PNMI_STRUCT_DATA *)0)->ReturnStatus.ErrorStatus));	\
	SK_PNMI_STORE_U32(pVal, Val32);									\
	Val32 = (o);													\
	pVal = (char *)(b) + ((SK_U32)(SK_UPTR)							\
		&(((SK_PNMI_STRUCT_DATA *)0)->ReturnStatus.ErrorOffset));	\
	SK_PNMI_STORE_U32(pVal, Val32);									\
}

/*
 * Time macros
 */
#if SK_TICKS_PER_SEC == 100
#define SK_PNMI_HUNDREDS_SEC(t)	(t)
#else
#define SK_PNMI_HUNDREDS_SEC(t)	(((t) * 100) / (SK_TICKS_PER_SEC))
#endif

/*
 * Macros to work around alignment problems
 */
#ifndef SK_PNMI_STORE_U16
#define SK_PNMI_STORE_U16(p,v)	{				\
	*(char *)(p) = *((char *)&(v)); 			\
	*((char *)(p) + 1) = *(((char *)&(v)) + 1);	\
}
#endif

#ifndef SK_PNMI_STORE_U32
#define SK_PNMI_STORE_U32(p,v)	{				\
	*(char *)(p) = *((char *)&(v));				\
	*((char *)(p) + 1) = *(((char *)&(v)) + 1);	\
	*((char *)(p) + 2) = *(((char *)&(v)) + 2);	\
	*((char *)(p) + 3) = *(((char *)&(v)) + 3);	\
}
#endif

#ifndef SK_PNMI_STORE_U64
#define SK_PNMI_STORE_U64(p,v)	{				\
	*(char *)(p) = *((char *)&(v));				\
	*((char *)(p) + 1) = *(((char *)&(v)) + 1);	\
	*((char *)(p) + 2) = *(((char *)&(v)) + 2);	\
	*((char *)(p) + 3) = *(((char *)&(v)) + 3);	\
	*((char *)(p) + 4) = *(((char *)&(v)) + 4);	\
	*((char *)(p) + 5) = *(((char *)&(v)) + 5);	\
	*((char *)(p) + 6) = *(((char *)&(v)) + 6);	\
	*((char *)(p) + 7) = *(((char *)&(v)) + 7);	\
}
#endif

#ifndef SK_PNMI_READ_U16
#define SK_PNMI_READ_U16(p,v)	{				\
	*((char *)&(v)) = *(char *)(p);				\
	*(((char *)&(v)) + 1) = *((char *)(p) + 1);	\
}
#endif

#ifndef SK_PNMI_READ_U32
#define SK_PNMI_READ_U32(p,v)	{				\
	*((char *)&(v)) = *(char *)(p);				\
	*(((char *)&(v)) + 1) = *((char *)(p) + 1);	\
	*(((char *)&(v)) + 2) = *((char *)(p) + 2);	\
	*(((char *)&(v)) + 3) = *((char *)(p) + 3);	\
}
#endif

#ifndef SK_PNMI_READ_U64
#define SK_PNMI_READ_U64(p,v)	{				\
	*((char *)&(v)) = *(char *)(p);				\
	*(((char *)&(v)) + 1) = *((char *)(p) + 1);	\
	*(((char *)&(v)) + 2) = *((char *)(p) + 2);	\
	*(((char *)&(v)) + 3) = *((char *)(p) + 3);	\
	*(((char *)&(v)) + 4) = *((char *)(p) + 4);	\
	*(((char *)&(v)) + 5) = *((char *)(p) + 5);	\
	*(((char *)&(v)) + 6) = *((char *)(p) + 6);	\
	*(((char *)&(v)) + 7) = *((char *)(p) + 7);	\
}
#endif

/*
 * Macros for Debug
 */
#ifdef DEBUG

#define SK_PNMI_CHECKFLAGS(vSt)
#if 0
{											\
	if (pAC->Pnmi.MacUpdatedFlag > 0 || 									\
		pAC->Pnmi.RlmtUpdatedFlag > 0 ||									\
		pAC->Pnmi.SirqUpdatedFlag > 0) {									\
		SK_DBG_MSG(pAC, SK_DBGMOD_PNMI, SK_DBGCAT_CTRL,						\
			("PNMI: ERR: %s MacUFlag=%d, RlmtUFlag=%d, SirqUFlag=%d\n", 	\
				vSt, pAC->Pnmi.MacUpdatedFlag, pAC->Pnmi.RlmtUpdatedFlag,	\
				pAC->Pnmi.SirqUpdatedFlag))									\
	}																		\
}
#endif	/* 0 */

#else	/* !DEBUG */

#define SK_PNMI_CHECKFLAGS(vSt)	/* Nothing */

#endif	/* !DEBUG */

#endif	/* _SKGIPNM2_H_ */
