/**********************************************************************
*h*
*
*   Name:               nsm.h
* 
*   Description:        NSM related data structures. 
*
*   Author:  
*
*   History:  
*
*h*   
**********************************************************************/
#define	MAX_PKTS  20
#define MAX_FRAGS 20

#include "hsm.h"

#ifndef _NSMCONTEXT_H
#define _NSMCONTEXT_H

#define NsmGetTime()  jiffies

#define NsmZeroMemory(MacStats, Size) memset((PVOID) (MacStats), 0, (Size))

#ifdef IOMAPPED_IO

#define NsmRegRead8(pNsm, ioaddr, pRegVal)  *(pRegVal) = inb((unsigned)(ioaddr))

#define NsmRegRead16(pNsm, ioaddr, pRegVal)  *(pRegVal) = inw((unsigned)(ioaddr))

#define NsmRegRead32(pNsm, ioaddr, pRegVal)  *(pRegVal) = inl((unsigned)(ioaddr))

#define NsmRegWrite8(pNsm,ioaddr,data)  outb((data),(unsigned)(ioaddr))

#define NsmRegWrite16(pNsm,ioaddr,data)  outw((data), (unsigned)(ioaddr))

#define NsmRegWrite32(pNsm,ioaddr, data)  outl((data),(unsigned)(ioaddr))

#elif MEMMAPPED_IO

#define NsmRegRead8(pNsm, ioaddr, pRegVal)  *(pRegVal) = readb((unsigned)(ioaddr))

#define NsmRegRead16(pNsm, ioaddr, pRegVal)  *(pRegVal) = readw((unsigned)(ioaddr))

#define NsmRegRead32(pNsm, ioaddr, pRegVal)  *(pRegVal) = readl((unsigned)(ioaddr))

#define NsmRegWrite8(pNsm,ioaddr,data)  writeb((data),(unsigned)(ioaddr))

#define NsmRegWrite16(pNsm,ioaddr,data)  writew((data), (unsigned)(ioaddr))

#define NsmRegWrite32(pNsm,ioaddr, data)  writel((data),(unsigned)(ioaddr))

#endif


#define NsmCompare(SrcMac, DestMac, len) CMP_ETH_ADDR((SrcMac),(DestMac),(len))

#define NsmResetComplete(pAdapter)

/* Nsmcontext structure */
typedef struct NsmInfo
{
	struct _AdapterContext AdpCtxt;
	struct net_device_stats *pAdapterStats;
	struct net_device *next;
	struct MacAddr *pMultiList;
	UINT	FilterFlags;
	UINT	status;
	struct net_device * dev;
	#ifdef	LINK_AGGR
		struct	netdevice *dev_aggr;
	#endif
} NsmContext;

typedef struct _EthHeader 
{
	UCHAR SrcAddr[6];
	UCHAR DstAddr[6];
	UINT size;
} EthHeader;

/* Tunable parameters */

#define MAX_PKTS	20
#define	MAX_FRAGS	20

#define	OK	SUCCESS
#define ERROR	FAILURE

#define BUF_SIZE_MAX 2048 
#define TX_QUEUE_SZ 200
#define RX_QUEUE_SZ 200 

#define TRUE 1
#define FALSE 0
#define DUPED 10

#define DRV_NAME "ga622t"
#define DEV_STARTED 1
#define ETH_MAX_PKT_SIZE 2000
#define MIN_PKT_SIZE 64
#define MAC_ADDR_LEN 6
#define PCI_DEVICE_ID_83820 0x0022
#define BITNO 1

#define PCI_IO_SIZE 256 
#define PCI_MEM_SIZE 4096 

#define DEV_INTERRUPTED 1
#define DEV_SERVICED_INTERRUPT 0
#define SLEEP_STATE 2
#define HEAD_SPACE 2 

#define REPL_BM 100

#define NSMMAPPKTS
#define NSMGETNUMFRAGS(NumFrags,pPkt) \
		NumFrags=pPkt->NumFrags

#define CACHE_LINE_SIZE 512

#define MAX_PRI_QUEUE	4
#define NSM_OPEN 0x00000001

/* Linux Network driver interface routines */

extern int DrvProbe (struct net_device *dev);
STATIC int DrvOpen (struct net_device *dev);
STATIC int DrvClose (struct net_device *dev);
STATIC int DrvSend (struct sk_buff *skb, struct net_device *dev);
STATIC VOID DrvSetMulticastList (struct net_device *dev);
int DrvSetMacAddress(struct net_device *dev, void *addr);
void DrvTxTimeout(struct net_device *dev);
STATIC int DrvIoctl( struct net_device *dev, struct ifreq *rq, int cmd );
STATIC struct net_device_stats* DrvGetStatistics(struct net_device *dev);
STATIC VOID DrvIsr (int irq, VOID *dev_id, struct pt_regs *regs);

STATIC int ChangeMtu(struct net_device *dev, int NewMtu);

/* Driver private routines */

STATIC VOID NsmTxCompleted(AdapterContext *pNsc, HsmTCB *TcbFirst, HsmTCB *TcbLast);

STATIC VOID NsmRxPackets (AdapterContext *pNsc, HsmRCB *RcbStart, HsmRCB *RcbEnd,
        UCHAR  Priority);

STATIC UCHAR  	NsmMallocContiguous(VOID *pNsm, 
	AddrStruct *pAddrStruct, USHORT Alignment, UINT Cached);
STATIC VOID 	NsmFreeContiguous(VOID *pNsm, AddrStruct *pAddrStruct, 
			UINT Cached);
STATIC UCHAR  	NsmAllocatePacket(VOID *pNsm, HsmRCB *pRcb, 
					AddrStruct *pAddr);
STATIC VOID 	NsmDeAllocatePacket(VOID *pNsm, AddrStruct *pAddr, 
	HsmRCB *pRcb );

inline VOID *   NsmMalloc(UINT size);	
STATIC UCHAR IsBrdCastOrMultiCast( struct net_device *dev, UCHAR *DestMac);
VOID CreatePacketStruct(struct sk_buff *skb, PktStruct *pPkt);
VOID CreatePacketInfo(struct sk_buff *skb, PktInfo *pPkt);

inline UCHAR CMP_ETH_ADDR(UCHAR *SrcMac,UCHAR *DestMac, UINT Len);

#define NsmMarkRcbFree(pRcb)  \
{ \
	struct sk_buff *skb = ((struct sk_buff *)((pRcb)->pOsCtrlBlk));  \
	if(!skb_cloned(skb)) \
        (pRcb)->Status = RCB_FREE; \
}

#define NsmFree(ptr,size) kfree(ptr)

inline VOID *NsmCreateLock(); 

inline VOID NsmAcquireLock(AdapterContext *pAdapter,VOID *LockId); 

inline VOID NsmReleaseLock(AdapterContext *pNsm, VOID *LockId); 

void NsmIndicateLinkStatus(AdapterContext *pAdapter);

#define NsmDestroyLock(pNsm, LockId) kfree(LockId)

#define NsmAcquireDPCLock(pNsm, LockId)

#define NsmReleaseDPCLock(pNsm, LockId)

#define NsmSleep(pNsm, SleepVal) mdelay(SleepVal);

#define NsmCopy(src, dest, MAC_ADDR_LEN) \
	memcpy((dest),(src),MAC_ADDR_LEN)	

#define NsmDbgMsg(x) 

#define NsmDbgMsg1(x,a1) 

#define NsmDbgMsg2(x,a1,a2) 

#define NsmDbgMsg3(x,a1,a2,a3) 

#define NsmDbgMsg4(x,a1,a2,a3,a4)

inline VOID PrintContents(UCHAR *start, UINT len);

#endif _NSMCONTEXT_H

