#include "gradm.h"

void
add_ip_acl(struct ip_acl **ipp, __u8 mode, struct ip_acl *acl_tmp)
{
	struct ip_acl *p;

	p = (struct ip_acl *) calloc(1, sizeof (struct ip_acl));
	if (!p)
		failure("calloc");

	if (*ipp)
		(*ipp)->next = p;

	p->prev = *ipp;

	if (mode == GR_IP_CONNECT)
		p->mode |= GR_IP_CONNECT;
	else if (mode == GR_IP_BIND)
		p->mode |= GR_IP_BIND;

	p->addr = acl_tmp->addr;
	p->netmask = acl_tmp->netmask;
	p->low = acl_tmp->low;
	p->high = acl_tmp->high;
	memcpy(p->proto, acl_tmp->proto, sizeof (acl_tmp->proto));
	p->type = acl_tmp->type;

	*ipp = p;

	return;
}

void
add_ip_ip_acl(struct ip_acl *ip_acl, char *ip, char *netmask,
	      char *low, char *high)
{
	unsigned int bits = atoi(netmask);
	struct in_addr address;

	if (!bits)
		ip_acl->netmask = 0UL;
	else
		ip_acl->netmask = 0xffffffff << (32 - bits);

	if (!inet_aton(ip, &address)) {
		fprintf(stderr, "Invalid IP on line %lu of %s.\n", lineno,
			current_acl_file);
		exit(EXIT_FAILURE);
	}

	ip_acl->addr = address.s_addr;
	ip_acl->low = atoi(low);
	ip_acl->high = atoi(high);

	return;
}
