#ifndef _VTUNE_IA32_FREG_TYPE_H
#define _VTUNE_IA32_FREG_TYPE_H

/*
 *  ia32_family_freg_type.h
 *
 *  Copyright (C) 2002 Intel Corporation 
 *  Author/Maintainer - George W Artz <george.w.artz@intel.com>
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */
/*
 *  Author(s): George Artz
 *
 *  system: IA32 VTune Linux Sampling Driver
 *
 */

#define CCCR_REG  1
#define COUNT_REG 2
#define PEBS_REG  3
#define ESCR_REG  4
#define UNKNOWN_REG 0

#define CCCR_FIRST 864
#define CCCR_LAST  881
#define COUNT_FIRST (CCCR_FIRST - 0x60)
#define COUNT_LAST  (CCCR_LAST  - 0x60)
#define ESCR_FIRST 928
#define ESCR_LAST  993

#define NUM_ESCRS (ESCR_LAST - ESCR_FIRST +1)
#define NUM_CCCRS (ESCR_LAST - ESCR_FIRST +1)

#endif /* _VTUNE_IA32_FREG_TYPE_H */

