/*
 * BK Id: SCCS/s.param.h 1.8 08/20/01 22:50:29 paulus
 */
#ifndef _ASM_PPC_PARAM_H
#define _ASM_PPC_PARAM_H

#include <linux/config.h>

#ifdef __KERNEL__
# define HZ		CONFIG_HZ	/* internal kernel timer frequency */
# define USER_HZ	100		/* some user interfaces are in ticks */
# define CLOCKS_PER_SEC	(USER_HZ)	/* like times() */
# define jiffies_to_clock_t(x)	((x) / ((HZ) / (USER_HZ)))
#endif

#ifndef HZ
#define HZ 100
#endif

#define EXEC_PAGESIZE	4096

#ifndef NGROUPS
#define NGROUPS		32
#endif

#ifndef NOGROUP
#define NOGROUP		(-1)
#endif

#define MAXHOSTNAMELEN	64	/* max length of hostname */

#endif
