#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/file.h>
#include <linux/fs.h>
#include <linux/types.h>
#include <linux/grdefs.h>
#include <linux/grinternal.h>
#include <linux/capability.h>

#include <asm/uaccess.h>

int
gr_handle_nproc(void)
{
#ifdef CONFIG_GRKERNSEC_EXECVE
	if (grsec_enable_execve && current->user &&
	    (atomic_read(&current->user->processes) >
	     current->rlim[RLIMIT_NPROC].rlim_cur) &&
	    !capable(CAP_SYS_ADMIN) && !capable(CAP_SYS_RESOURCE)) {
		security_alert(GR_NPROC_MSG, DEFAULTSECARGS);
		return -EAGAIN;
	}
#endif
	return 0;
}

void
gr_handle_exec_args(struct linux_binprm *bprm, char **argv)
{
#ifdef CONFIG_GRKERNSEC_EXECLOG
	char grarg[64] = { 0 };
	__u8 execlen = 0;
	unsigned int i;

	if (!((grsec_enable_execlog && grsec_enable_group &&
	       in_group_p(grsec_audit_gid))
	      || (grsec_enable_execlog && !grsec_enable_group)))
		return;

	if (unlikely(!argv))
		goto log;

	for (i = 0; i < bprm->argc && execlen < 62; i++) {
		char *p;
		__u8 len;

		if (get_user(p, argv + i))
			goto log;
		if (!p)
			goto log;
		len = strnlen_user(p, 62 - execlen);
		if (len > 62 - execlen)
			len = 62 - execlen;
		else if (len > 0)
			len--;
		if (copy_from_user(grarg + execlen, p, len))
			goto log;
		execlen += len;
		*(grarg + execlen) = ' ';
		*(grarg + execlen + 1) = '\0';
		execlen++;
	}

      log:
	security_audit(GR_EXEC_AUDIT_MSG, gr_to_filename(bprm->file->f_dentry,
							 bprm->file->f_vfsmnt),
		       grarg, DEFAULTSECARGS);
#endif
	return;
}
