#ifndef _SHFS_DEBUG_H_
#define _SHFS_DEBUG_H_

#if DEBUG_LEVEL >= 1
#	define SHFS_VERBOSE
#endif
#if DEBUG_LEVEL >= 2
#	define SHFS_ALLOC_DEBUG
#endif
#if DEBUG_LEVEL >= 3
#	define SHFS_DEBUG
#endif

#ifdef SHFS_DEBUG
#define DEBUG(x...) do { printk(KERN_DEBUG "%s: ", __FUNCTION__); printk(x); } while (0)
#else
#define DEBUG(x...) ;
#endif

#ifdef SHFS_VERBOSE
#define VERBOSE(x...) do { printk(KERN_NOTICE "%s: ", __FUNCTION__); printk(x); } while (0)
#else
#define VERBOSE(x...) ;
#endif

#ifdef SHFS_ALLOC_DEBUG

#include <linux/slab.h>

extern unsigned long alloc;

#ifdef SHFS_DEBUG_HERE

void *__kmem_malloc_debug(char *s, kmem_cache_t *cache, int flags)
{
	void *x = kmem_cache_alloc(cache, flags);
	alloc += (unsigned long) x;
	VERBOSE("alloc (%s): %p\n", s, x);
	return x;
}

void __kmem_free_debug(char *s, kmem_cache_t *cache, void *p)
{
	VERBOSE("free (%s): %p\n", s, p);
	alloc -= (unsigned long) p;
	kmem_cache_free(cache, p);
}
#else

void *__kmem_malloc_debug(char *s, kmem_cache_t *cache, int flags);
void __kmem_free_debug(char *s, kmem_cache_t *cache, void *p);
#endif

#define KMEM_ALLOC(s, cache, flags) __kmem_malloc_debug(s, cache, flags);
#define KMEM_FREE(s, cache, p) __kmem_free_debug(s, cache, p);

#else
#define KMEM_ALLOC(s, cache, flags) kmem_cache_alloc(cache, flags)
#define KMEM_FREE(s, cache, p) kmem_cache_free(cache, p)
#endif

#endif	/* _SHFS_DEBUG_H_ */
