/******************************************************************************
 *
 * Name:	skerror.h
 * Project:	SysKonnect SK-9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.1 $
 * Date:	$Date: 2001/06/05 08:28:24 $
 * Purpose:	SK-specific error log support.
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * History:
 *
 *	$Log: skerror.h,v $
 *	Revision 1.1  2001/06/05 08:28:24  rassmann
 *	First public version.
 *	
 *
 ******************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 * This module provides definitions for error log support.
 *
 ******************************************************************************/

#ifndef _INC_SKERROR_H_
#define _INC_SKERROR_H_

/*
 * Define the Error Classes
 */
#define	SK_ERRCL_OTHER		(0)		/* Other error */
#define	SK_ERRCL_CONFIG		(1L<<0)	/* Configuration error */
#define	SK_ERRCL_INIT		(1L<<1)	/* Initialization error */
#define	SK_ERRCL_NORES		(1L<<2)	/* Out of resources error */
#define	SK_ERRCL_SW			(1L<<3)	/* internal Software error */
#define	SK_ERRCL_HW			(1L<<4)	/* Hardware failure */
#define	SK_ERRCL_COMM		(1L<<5)	/* Communication error */


/*
 * Define Error code bases
 */
#define	SK_ERRBASE_RLMT		100		/* Base Error number for RLMT */
#define	SK_ERRBASE_HWINIT	200		/* Base Error number for HWInit */
#define	SK_ERRBASE_VPD		300		/* Base Error number for VPD */
#define	SK_ERRBASE_PNMI		400		/* Base Error number for PNMI */
#define	SK_ERRBASE_CSUM		500		/* Base Error number for Checksum */
#define	SK_ERRBASE_SIRQ		600		/* Base Error number for Special IRQ */
#define	SK_ERRBASE_I2C		700		/* Base Error number for i2C module */
#define	SK_ERRBASE_QUEUE	800		/* Base Error number for Scheduler */
#define	SK_ERRBASE_ADDR		900		/* Base Error number for Address mod. */
#define SK_ERRBASE_PECP		1000    /* Base Error number for PECP */
#define	SK_ERRBASE_DRV		1100	/* Base Error number for Driver */

#endif	/* _INC_SKERROR_H_ */

