/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Manages access to available frame pool; generic frame builders 
 */

#ifndef CM_FRAME_H
#define CM_FRAME_H

/* Netbios frame transmission types */
#define FRAME_TX_UI_FUNC_ADDR_SRB      1
#define FRAME_TX_UI_SPEC_ADDR_NB       2
#define FRAME_TX_UI_SPEC_ADDR_GB       3
#define FRAME_TX_I_SPEC_ADDR_NB        4


#define FRAME_OWNER_NETWORK            1
#define FRAME_OWNER_LLC                2
#define FRAME_OWNER_MAC                3

#define FRAME_TYPE_PDU                 1
#define FRAME_TYPE_DATA                2


/* Frame object; contains all the resources to support a single frame */
typedef struct _frame_t
{
   us8                 mac_type;           /* MAC-level protocol */
   us8 *               mac_hdr;            /* ptr to MAC header */
   us8 *               llc_hdr;            /* ptr to LLC header */
   us16                free_frame_flag;    /* if LLC can free frame on tx */
   us16                data_size;
   void *              skb;                /* (struct sk_buff *) in here */
   void *              dev;                /* (struct device *) in here */
   void *              pt;                 /* (struct packet_type *) here */
} frame_t;


#ifndef CM_FRAME_C
#define EXTRN extern
#else
#define EXTRN
#endif /* CM_FRAME_C */


EXTRN us16         frame_init (void);
EXTRN us16         frame_exit (void);
EXTRN us16         frame_allocate (frame_t ** new_frame);
EXTRN us16         frame_pdu_allocate (frame_t ** new_frame);
EXTRN us16         frame_free (frame_t * frame);
EXTRN us16         frame_skb_free (frame_t * frame);

#undef EXTRN
#endif /* CM_FRAME_H */
